//	DStream.h

#pragma once

#ifndef _DSTREAM_H_
#define _DSTREAM_H_

#include <Object.h>


class DStream :
	public virtual BObject
{
protected:
		bool					fDispose;
public:

inline							DStream() {
									fDispose = TRUE;
								}

	/*	All of these functions should be implemented by 
	 *	subclasses. Streams going from the network should 
	 *	still be prepared to handle seeks, since the 
	 *	identify method will re-seek back to the beginning 
	 *	quite a lot, and many data formats require seeks 
	 *	as well
	 */
virtual	long					Read(	//	returns 0 for success
									void * buffer,
									long & size) = 0;
virtual	long					Write(	//	returns 0 for success
									const void * data,
									long size) = 0;
virtual	long					Seek(	//	returns 0 for success
									long position) = 0;
virtual	long					Position() = 0; // returns position
virtual long					Size() = 0; // returns total size
virtual	long					SetSize(	//	returns 0 for success
									long size) = 0;

inline	void					SetDispose(
									bool dispose) {
									fDispose = dispose;
								}
};

#endif // _DSTREAM_H_

